﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class Quotations : BusinessBaseClass
    {

        public Quotations()
        {
            QuotationsDetailsList = new List<QuotationsDetails>();
        }

        public Quotations(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("QuotationsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("QuotationsID"));
            OrderFrom = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("OrderFrom")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("OrderFrom"));
            UsersAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UsersAccountID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("UsersAccountID"));
            FirstName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("FirstName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("FirstName"));
            LastName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("LastName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("LastName"));
            Email = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Email")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Email"));
            Company = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Company")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Company"));
            BillingAddress1 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingAddress1")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingAddress1"));
            BillingAddress2 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingAddress2")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingAddress2"));
            BillingCity = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingCity")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingCity"));
            BillingState = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingState")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingState"));
            BillingCountry = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingCountry")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingCountry"));
            BillingPostalCode = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingPostalCode")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingPostalCode"));
            BillingMobile = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingMobile")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingMobile"));
            BillingPhone = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("BillingPhone")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("BillingPhone"));
            ShippingAddress1 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingAddress1")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingAddress1"));
            ShippingAddress2 = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingAddress2")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingAddress2"));
            ShippingCity = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingCity")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingCity"));
            ShippingState = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingState")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingState"));
            ShippingCountry = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingCountry")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingCountry"));
            ShippingPostalCode = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingPostalCode")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingPostalCode"));
            ShippingMobile = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingMobile")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingMobile"));
            ShippingPhone = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ShippingPhone")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("ShippingPhone"));
            IsShipToBillingAddress = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsShipToBillingAddress")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsShipToBillingAddress"));
            SubTotal = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("SubTotal")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("SubTotal"));
            Discount = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Discount")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Discount"));
            Shipping = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Shipping")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Shipping"));
            TotalBeforeGST = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TotalBeforeGST")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("TotalBeforeGST"));
            GST = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("GST")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("GST"));
            Total = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Total")) ? 0 : myDataRecord.GetDecimal(myDataRecord.GetOrdinal("Total"));
            QuotationsNumber = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("QuotationsNumber")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("QuotationsNumber"));
            QuotationsStatus = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("QuotationsStatus")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("QuotationsStatus"));
            ExpiryDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ExpiryDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ExpiryDate"));
            DesignerName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DesignerName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DesignerName"));
            DesignerRemarks = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("DesignerRemarks")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("DesignerRemarks"));
            AdminUserAccountID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public string OrderFrom { get; set; }

        public Guid UsersAccountID { get; set; }

        public string FirstName { get; set; }

        public string LastName { get; set; }

        public string Email { get; set; }

        public string Company { get; set; }

        public string BillingAddress1 { get; set; }

        public string BillingAddress2 { get; set; }

        public string BillingCity { get; set; }

        public string BillingState { get; set; }

        public string BillingCountry { get; set; }

        public string BillingPostalCode { get; set; }

        public string BillingMobile { get; set; }

        public string BillingPhone { get; set; }

        public string ShippingAddress1 { get; set; }

        public string ShippingAddress2 { get; set; }

        public string ShippingCity { get; set; }

        public string ShippingState { get; set; }

        public string ShippingCountry { get; set; }

        public string ShippingPostalCode { get; set; }

        public string ShippingMobile { get; set; }

        public string ShippingPhone { get; set; }

        public bool IsShipToBillingAddress { get; set; }

        public decimal SubTotal { get; set; }

        public decimal Discount { get; set; }

        public decimal Shipping { get; set; }

        public decimal TotalBeforeGST { get; set; }

        public decimal GST { get; set; }

        public decimal Total { get; set; }

        public string Comments { get; set; }

        public string QuotationsNumber { get; set; }

        public string QuotationsStatus { get; set; }

        public DateTime ExpiryDate { get; set; }

        public string DesignerName { get; set; }

        public string DesignerRemarks { get; set; }

        public Guid AdminUserAccountID { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }

        //public override bool IsDeleted { get; set; }

        public List<QuotationsDetails> QuotationsDetailsList;
    }
}
